//
//  testbasicapp.m
//  HNSAppKit
//
//  Created by Dr. H. Nikolaus Schaller on Sun Feb 23 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import "testbasicapp.h"
#import <HNSAppKit/HNSBasicCompiler.h>
#import <HNSAppKit/HNSSyntaxAwareTextView.h>
#import <HNSAppKit/HNSPluginLoader.h>

@implementation TestBasicApp

- (id) init
{
	self=[super init];
#if 0
	NSLog(@"testbasicapp: init");
#endif
	return self;
}

- (void) awakeFromNib;
{
#if 0
	NSLog(@"testbasicapp: awakeFromNib");
	NSLog(@"scriptView: %@", scriptView);
	NSLog(@"resultView: %@", resultView);
	NSLog(@"alpha: %@", alpha);
	NSLog(@"cocoaScript: %@", cocoaScript);
#endif
	[NSBundle loadPlugins];
#if 0
	[[[[NSWindow alloc] initWithContentRect:NSMakeRect(0.0, 0.0, 100.0, 100.0) styleMask:7+256 backing:0 defer:NO] retain] orderFront:nil];
#endif
#if 0
	{
		struct { char c; } s;
	NSLog(@"&s.c %08lx", &s.c);
	}
#endif
//	[NSApp setDelegate:self];
//	[source setKeywordResourceFile:@"HNSBasicKeyWords.plist"];
}

- (Class) loadAbout;
{
	NSBundle *thisBundle;
	NSString *bundleToLoadPath;
	NSBundle *bundleToLoad;
	Class loadedClass;

	thisBundle=[NSBundle mainBundle];
#if 0
	NSLog(@"this bundle:%@\n", thisBundle);
#endif

	bundleToLoadPath=[thisBundle pathForResource:@"About" ofType:@"bundle"];	// path for bundle to load
#if 0
	NSLog(@"bundle path:%@\n", bundleToLoadPath);
#endif
	bundleToLoad = [NSBundle bundleWithPath:bundleToLoadPath];	// locate bundle to load
#if 0
	NSLog(@"bundle to load:%@\n", bundleToLoad);
#endif
	loadedClass = [bundleToLoad principalClass];
#if 0
	NSLog(@"loaded class:%@\n", loadedClass);
#endif
	// if exists
	return loadedClass;
}

- (IBAction) orderFrontStandardAboutPanel:(id) Sender
{
	[[self loadAbout] open];
}

- (IBAction) requestFeature:(id) Sender;
{
	[[self loadAbout] requestFeature];
}

- (IBAction) reportBug:(id) Sender;
{
	[[self loadAbout] reportBug];
}

- (IBAction) compileScript:(id) Sender;
{
	NSScanner *sc;
	HNSCocoaScript *s;
#if 0
	NSLog(@"compile: %@", [scriptView string]);
#endif
	NS_DURING	// set up exception handler!
		sc=[NSScanner scannerWithString:[scriptView string]];
		s=[HNSCocoaScript scriptFromScanner:sc];
		[self setResult:[s description]];
	NS_HANDLER
		{ // exception, i.e. syntax error or alike
			unsigned int l=[sc scanLocation];
			NSRange r;
#if 0
			NSLog(@"%@", sc);
#endif
			if(l>10)
				r=NSMakeRange(l-10, 20);
			else
				r=NSMakeRange(0, 20);
#if 0
			NSLog(@"%@", NSStringFromRange(r));
#endif
			r=NSIntersectionRange(r, NSMakeRange(0, [[sc string] length]));
#if 0
			NSLog(@"%@", NSStringFromRange(r));
#endif
			NSRunAlertPanel([localException name], @"%@:\n%@", @"OK", nil, nil, localException, [[sc string] substringWithRange:r]);
		}
	NS_ENDHANDLER
}

- (IBAction) compileScript2ObjC:(id) Sender;
{
	NSScanner *sc;
	HNSCocoaScript *s;
#if 0
	NSLog(@"compile: %@", [scriptView string]);
#endif
	NS_DURING	// set up exception handler!
		sc=[NSScanner scannerWithString:[scriptView string]];
		s=[HNSCocoaScript scriptFromScanner:sc];
		[self setResult:[s makeObjectiveC]];
	NS_HANDLER
		{ // exception, i.e. syntax error or alike
			unsigned int l=[sc scanLocation];
			NSRange r;
#if 0
			NSLog(@"%@", sc);
#endif
			if(l>10)
				r=NSMakeRange(l-10, 20);
			else
				r=NSMakeRange(0, 20);
#if 0
			NSLog(@"%@", NSStringFromRange(r));
#endif
			r=NSIntersectionRange(r, NSMakeRange(0, [[sc string] length]));
#if 0
			NSLog(@"%@", NSStringFromRange(r));
#endif
			NSRunAlertPanel([localException name], @"%@:\n%@", @"OK", nil, nil, localException, [[sc string] substringWithRange:r]);
		}
	NS_ENDHANDLER
}

- (IBAction) runScript:(id) Sender;
{
	id r;
	NSScanner *sc;
	HNSCocoaScript *s;
	NS_DURING	// set up exception handler!
		sc=[NSScanner scannerWithString:[scriptView string]];
		s=[HNSCocoaScript scriptFromScanner:sc];
		[self setResult:[s description]];
#if 0
		NSLog(@"script: %@", s);
		NSLog(@"main method: %@", NSStringFromSelector([s method]));
#endif
		if([s method] == @selector(defineMethod:ofType:andArgs:asScript:))
			{ // standard return of compiled basic script
			r=[[s right] objectAtIndex:3];	// get script
#if 0
			NSLog(@"script: %@", r);
#endif
			r=[r eval];	// explicitly evaluate script which is a CSprocedure covered by CSEVALSHIELD
			r=[r eval];	// evaluate procedure
#if 0
			NSLog(@"evaluated script: %@", r);
#endif
			}
		else
			r=[s eval];
		if(r != nil)
			NSRunAlertPanel(@"Result", @"%@", @"OK", nil, nil, r);
	NS_HANDLER
		{ // runtime exception
			NSRunAlertPanel([localException name], @"Runtime Exception:\n%@", @"OK", nil, nil, localException);
		}
	NS_ENDHANDLER
}

- (void) setScript:(NSString *) s;
{
#if 0
	NSLog(@"setScript %@", s);
#endif
	[scriptView setString:s];
}

- (void) setResult:(NSString *) r;
{
#if 0
	NSLog(@"setResult %@", r);
#endif
	[resultView setString:r];
}

@end
